<?php
    defined('PF_VERSION') OR exit('Access denied');
    function aphrodite_default() {
        return array('version'                 => '',
                     'logo-text' => 'PageFlex',
                     'logo-image' => '',
                     'logo-image-width'        => '180px',
                     'logo-image-height' => '56px',
                     'logo' => 'text',
                     'logo-font-size'          => '22px',
                     'logo-font-family' => 'Lobster, cursive',
                     'logo-color'              => '#333333',

                     'body-class'              => 'body-green',
                     'body-font-family'        => 'font-family: Arial, Helvetica, sans-serif',
                     'body-font-size' => '',
                     'body-color'              => '',

                     'google-font'             => "<link href='http://fonts.googleapis.com/css?family=Lobster|Oswald' rel='stylesheet' type='text/css'>",
                     'color' => 'theme', 'custom_color' => '#27ae60',

                     'background'              => 'color',
                     'background-image' => '',
                     'background-repeat' => 'repeat',
                     'background-position'     => 'top center',
                     'background-attachment' => 'scroll',
                     'background-color'        => '#ecf0f1',
                     'wrapper-background-color' => '#ffffff',

                     'navigation-font-size'    => '14px',
                     'navigation-font-family'  => 'font-family: \'Helvetica Neue\', Helvetica, Arial, sans-serif;',
                     'navigation-color'        => '#333333',
                     'navigation-hover-color'        => '#ffffff',
                     'navigation-background-color' => '#ffffff',

                     'title-font-size'         => '',
                     'title-font-family' => '',

                     'content-font-size'       => '',
                     'content-font-family' => 'Helvetica, \'sans-serif\';',

                     'bottom-font-size'        => '',
                     'bottom-font-family' => '',
                     'bottom-color' => '#95a5a6',
                     'bottom-background-color' => '#282A2B',
                     'bottom_content' => '
<p class="text-center">Copyright © {php:datetime} by PageFlex</p>
            ',
                     'footer-title-color'=>'#ffffff',
                     'footer-title-font-size'=>'20px',
                     'footer-title-font-family'=>'font-family: Arial, Helvetica, sans-serif',
                     'footer-content-color'=>'#d9d9d9',
                     'footer-content-font-size'=>'',
                     'footer-content-font-family'=>'',
                     'footer-background-color' => '#363839',
        );
    }

    function get_aphrodite_logo($aphrodite_options) {
        if ($aphrodite_options['logo'] == 'text') {
            $logoImage = isset($aphrodite_options['logo-text']) ? $aphrodite_options['logo-text'] : 'PageFlex';
        } else {
            if (isset($aphrodite_options['logo-image']) && $aphrodite_options['logo-image'] != ''):
                $url      = $aphrodite_options['logo-image'];
                if(!preg_match('/^http/', $url)){
                    $relative = RELATIVE_PATH;
                    if(empty($relative)){
                        $url =  site_url() . '/' . $url;
                    }else{
                        $url = site_url() . "{$relative}/{$url}";
                    }
                }
                $logoImage = '<img src="' . $url . '" alt="';
                $logoImage .= (isset($aphrodite_options['logo-text']) ? $aphrodite_options['logo-text'] : 'PageFlex');
                $logoImage .= '" style="';
                $logoImage .= 'width:' . (isset($aphrodite_options['logo-image-width']) ? $aphrodite_options['logo-image-width'] : '100%') . ';';
                $logoImage .= 'height:' . (isset($aphrodite_options['logo-image-height']) ? $aphrodite_options['logo-image-height'] : '100%');
                $logoImage .= ';">';
            else:
                $logoImage = isset($aphrodite_options['logo-text']) ? $aphrodite_options['logo-text'] : 'PageFlex';
            endif;
        }

        return $logoImage;
    }
    function get_google_fonts($google){
        if ($google != '') {
            if (!preg_match('/^(<link)/', trim($google))) {
                return '<link href="' . $google . '" rel="stylesheet" type="text/css">';
            } else {
                return $google;
            }
        }
    }
    function set_aphrodite_css($data) {
        $style = null;
        $body_class = '.'.$data['body-class'];
        if(isset($data['color']) && $data['color'] != 'theme' && $data['custom_color'] != ''){
            $body_class = '.body-custom';
            $custom_color = $data['custom_color'];

            $rgba = $custom_color;
            if(preg_match('/^(#)/',$custom_color)){
                $tmp = hex2_to_rgb($custom_color);
                $tmp[] = '0.6';
                $rgba = 'rgba(' . implode(',', $tmp) . ')';
            }elseif(preg_match('/^(rgb)/',$custom_color)){
                $tmp = explode(')', $custom_color);
                $tmp[end($tmp)] = '0.6' . $tmp[end($tmp)] . ')';
                $tmp[end($tmp)];
                foreach($tmp as $k=>$v){
                    if($v == ''){unset($tmp[$k]);}
                }
                $rgba = implode(',', $tmp);
                $rgba = str_replace('rgb','rgba', $rgba);
            }else{
                $tmp = get_color_RGB($custom_color);
                if(is_array($tmp)){
                    $tmp[] = '0.6';
                    $rgba = 'rgba(' . implode(',', $tmp) . ')';
                }
            }
            # Theme custom
            $css_template = '.body-custom .text-color,.body-custom a{';
            $css_template .= 'color:' . $custom_color . ';}';
            $css_template .= '.body-custom .border-color{';
            $css_template .= 'border-color:' . $custom_color .';}';
            $css_template .= '.body-custom .background-color{';
            $css_template .= 'background-color:' . $custom_color . ';}';
            $css_template .= '.body-custom .bg-hover-color:hover,';
            $css_template .= '.body-custom .bg-hover-color.active{';
            $css_template .= 'background-color:' .$custom_color . ';}';
            $css_template .= '.body-custom .btn-link:hover{';
            $css_template .= 'color:' . $custom_color . ';}';
            $css_template .= '.body-custom .btn-color{';
            $css_template .= 'background-color:' . $custom_color . ';}';
            $css_template .= '.body-custom footer a:hover{';
            $css_template .= 'color:' . $custom_color . '!important;}';
            $css_template .= '.body-custom .footer h3{';
            $css_template .= 'color:' . $custom_color . ';';
            $css_template .= 'text-shadow:1px 2px 1px #000;}';
            $css_template .= '.body-custom .footer a:hover{';
            $css_template .= 'color:' . $custom_color . '!important;}';
            $css_template .= '.body-custom .navbar-inverse .navbar-nav>.active>a,';
            $css_template .= '.body-custom .navbar-inverse .navbar-nav>.active>a:focus,';
            $css_template .= '.body-custom .navbar-inverse .navbar-nav>.active>a:hover,';
            $css_template .= '.body-custom .navbar-inverse .navbar-nav>.open>a,';
            $css_template .= '.body-custom .navbar-inverse .navbar-nav>.open>a:focus,';
            $css_template .= '.body-custom .navbar-inverse .navbar-nav>.open>a:hover,';
            $css_template .= '.body-custom .navbar-inverse .navbar-nav>li>a:focus,';
            $css_template .= '.body-custom .navbar-inverse .navbar-nav>li>a:hover{';
            $css_template .= 'color:' . $custom_color . ';background-color:transparent;}';
            $css_template .= '.body-custom .cancel-on-png,';
            $css_template .= '.body-custom .cancel-off-png,';
            $css_template .= '.body-custom .star-on-png,';
            $css_template .= '.body-custom .star-off-png,';
            $css_template .= '.body-custom .star-half-png{';
            $css_template .= 'color:' . $custom_color . ';}';
            $css_template .= '.body-custom .navbar-inverse .navbar-nav > li:hover{';
            $css_template .= 'background-color:' . $custom_color . ';}';
            $css_template .= '.body-custom .navbar-inverse .navbar-nav > li:hover{';
            $css_template .= 'background-color:' . $custom_color . ' ;}';
            $css_template .= '.body-custom .active-color {';
            $css_template .= 'background-color:' . $custom_color . ' !important;}';
            $css_template .= '.body-custom .btn-color:active,';
            $css_template .= '.body-custom .btn-color:focus,';
            $css_template .= '.body-custom .btn-color:hover,';
            $css_template .= '.body-custom .bg-hover-color:hover{opacity:.95}';
            $css_template .= '.body-custom .opacity-color,';
            $css_template .= '.navbar-nav li#search .search-box{';
            $css_template .= 'background-color:' . $rgba . ';}';
            $css_template .= '.body-custom .cancel-on-png,.body-custom .cancel-off-png,.body-custom .star-on-png,.body-custom .star-off-png,.body-custom .star-half-png{';
            $css_template .= 'color:' . $custom_color . ' !important;}';

            $style .=  $css_template;
        }
        #body & wrapper
        $body = null;
        if ($data['background'] == 'color') {
            if($data['background-color'] != ''){
                $body .= 'background-color:' . $data['background-color'] . ';';
            }
            if($data['wrapper-background-color'] != ''){
                $wrapper = '.container{background-color: ' . $data['wrapper-background-color'] . ';}';
            }
        } else {
            if (($data['background-image'] != '')) {
                if (preg_match('/^http/', $data['background-image'])) {
                    $body .= 'background-image: url(\'' . $data['background-image'] . '\');';
                } else {
                    $body .= 'background-image: url(\'' .site_url(). RELATIVE_PATH . '/' . $data['background-image'] . '\');';
                }
            }
            $body .= ($data['background-repeat'] != '') ? 'background-repeat: ' . $data['background-repeat'] . ';' : '';
            $body .= ($data['background-position'] != '') ? 'background-position: ' . $data['background-position'] . ';' : '';
            $body .= ($data['background-attachment'] != '') ? 'background-attachment: ' . $data['background-attachment'] . ';' : '';
            if ($data['background'] == 'both') {
                $body .= ($data['background-color'] != '') ? 'background-color: ' . $data['background-color'] . ';' : '';
                $wrapper = ($data['wrapper-background-color'] != '') ? '.container{background-color: ' . $data['wrapper-background-color'] . ';}' : '';
            }
        }
        $body .= ($data['body-font-family'] == '') ? '' : get_aphrodite_font_family($data['body-font-family']);
        $body .= ($data['body-font-size'] == '') ? '' : 'font-size:' . $data['body-font-size'] . ';';
        $body .= ($data['body-color'] == '') ? '' : 'color:' . $data['body-color'] . ';';
        $style .= ($body == null) ? '' : 'body{' . $body . '}';
        $style .= isset($wrapper) ? $wrapper : '';

        #navigation
        $navigation = null;
        $navigation .= ($data['navigation-font-family'] == '') ? '' : get_aphrodite_font_family($data['navigation-font-family']);
        $navigation .= ($data['navigation-font-size'] == '') ? '' : 'font-size:' . $data['navigation-font-size'] . ';';
        $navigation .= ($data['navigation-color'] == '') ? '' : 'color:' . $data['navigation-color'] . ';';
        $style .= '#nav-wrap, #nav-wrap li, #nav-wrap a{' . $navigation . '}';

        $style .= '.navbar-inverse,';
        $style .= '#navbar-collapse{';
        $style .= 'background-color: ' . $data['navigation-background-color'] . '}';

        $style .= '.navbar-inverse{';
        $style .= 'border-left-color:' . $data['navigation-background-color'] . ';';
        $style .= 'border-top-color:' . $data['navigation-background-color'] . ';';
        $style .= 'border-right-color:' . $data['navigation-background-color'] . ';';
        $style .= '}';
        $style .= ($data['navigation-color'] == '') ? '' : '.nav-color, .nav-color>a{color: ' . $data['navigation-color'] . ';}';
        $style .= ($data['navigation-color'] == '') ? '' : '.nav-color{color:' . $data['navigation-color'] .';}';

        $style .= '#nav-wrap .main-menu li>a>i,';
        $style .= '#nav-wrap .main-menu li.active-color>a>i{';
        $style .= ($data['navigation-color'] == '') ? '' : 'border-top-color:' .$data['navigation-color'] . ';';
        $style .= ($data['navigation-color'] == '') ? '' : 'border-bottom-color:' . $data['navigation-color'] . ';';
        $style .= '}';
        $style .= '#nav-wrap .main-menu li:hover>a>i,';
        $style .= '#nav-wrap .main-menu li.active-color>a>i{';
        $style .= ($data['navigation-hover-color'] == '') ? '' : 'border-top-color:' .$data['navigation-hover-color'] . ';';
        $style .= ($data['navigation-hover-color'] == '') ? '' : 'border-bottom-color:' . $data['navigation-hover-color'] . ';';
        $style .= '}';

        //        +tag
        $style .= '.tags > a ,';
        $style .= $body_class .' .tags > a ,';
        $style .= '.footer .widget-tags .widget-content a.a-tag{';
        $style .= ($data['navigation-hover-color'] == '') ? '' : 'color: '.$data['navigation-hover-color'] . ' !important;';
        $style .= '}';

        $style .= '#nav-wrap .main-menu li:hover>a,';
        $style .= '#nav-wrap .main-menu li.active-color>a,';
        $style .= '#nav-wrap .main-menu li.active-color>a>i,';
        $style .= '.nav-color:hover, .nav-color.active{';
        $style .= ($data['navigation-hover-color'] == '') ? '' : 'color: '.$data['navigation-hover-color'] . ';';
        $style .= '}';

        #logo
        $logo  = null;
        $logo .= ($data['logo-font-family'] == '') ? '' : get_aphrodite_font_family($data['logo-font-family']);
        $logo .= ($data['logo-font-size'] == '') ? '' : 'font-size:' . $data['logo-font-size'] . ';';
        $logo .= ($data['logo-color'] == '') ? '' : 'color:' . $data['logo-color'] . ';';
        $style .= 'a#logo {' . $logo . '}';
        #title
        $title = null;
        $title .= ($data['title-font-family'] == '') ? '' : get_aphrodite_font_family($data['title-font-family']);

        $title_class = null;
        for($i=1; $i<7;$i++){

            $title_class .= $body_class . ' .aphrodite-title,';
            $title_class .= $body_class . ' .aphrodite-title a,';

            $heading = null;
            $heading .= 'h'. $i . ',';
            $heading .= 'h'. $i . ' a,';
            $heading .= '.' . $data['body-class'] . ' h'. $i . ',';
            $heading .= '.' . $data['body-class'] . ' h'. $i . ' a';

//            $style .= $heading;
//            $style .= ($data['title-font-size'.$i] == '') ? '' : '{font-size:' . $data['title-font-size-'.$i] . ';}';

            $title_class .= $heading . ',';
        }

        $title_class .= '.title, .aphrodite-title, .aphrodite-title a';
        $style .= '.title, .aphrodite-title{';
        $style .= ($data['title-font-size'] == '') ? '' : '{font-size:' . $data['title-font-size'] . ';}';
        $style .= '}';
        $style .= $title_class . '{' . $title . '}';
        #content
        $content = null;
        $content .= ($data['content-font-family'] == '') ? '' : get_aphrodite_font_family($data['content-font-family']);
        $content .= ($data['content-font-size'] == '') ? '' : 'font-size:' . $data['content-font-size'] . ';';
        $style .= '.content,.aphrodite-content, .widget-content{' . $content . '}';

        # footer
        if($data['footer-background-color'] != ''){
            $style .= '.footer,.footer .container{';
            $style .= 'background-color:' . $data['footer-background-color'] . ';}';
        }

        $style .= '.footer .widgets h3.widget-title{';
        $style .= ($data['footer-title-font-family'] == '') ? '' : get_aphrodite_font_family($data['footer-title-font-family']);
        $style .= ($data['footer-title-font-size'] == '') ? '' : 'font-size:' . $data['footer-title-font-size'] . ';';
        $style .= ($data['footer-title-color'] == '') ? '' : 'color:' . $data['footer-title-color'] . ';';
        $style .= '}';

        $style .= '.footer .widgets .widget-content{';
        $style .= ($data['footer-content-font-family'] == '') ? '' : get_aphrodite_font_family($data['footer-content-font-family'] );
        $style .= ($data['footer-content-font-size'] == '') ? '' : 'font-size:' . $data['footer-content-font-size'] . '; ';
        $style .= ($data['footer-content-color'] == '') ? '' : 'color:' . $data['footer-content-color'] . ';';
        $style .= '}';

        $style .= '.footer .widgets .widget-content a,';
        $style .= '.footer .widgets .widget-content li a {';
        $style .= 'color:' . $data['footer-content-color'] . ' !important;';
        $style .= '}';
        $style .= '.footer .widgets .widget-content a:hover,';
        $style .= '.footer .widgets .widget-content li:hover a {opacity: 0.9}';
        #bottom
        $style .= '.copyright .container,.copyright{';
        $style .= 'background-color:' . $data['bottom-background-color'] . ';';
        $style .= '}';

        $bottom = null;
        $bottom .= ($data['bottom-font-family'] == '') ? '' : get_aphrodite_font_family($data['bottom-font-family']);
        $bottom .= ($data['bottom-font-size'] == '') ? '' : 'font-size:' . $data['bottom-font-size'] . ';';
        $bottom .= ($data['bottom-color'] == '') ? '' : 'color:' . $data['bottom-color'] . ';';

        $style .= '.bottom-content,.bottom-content li,.bottom-content li a,';
        $style .= '.bottom-content a, .bottom-content h1,.bottom-content h2,';
        $style .= '.bottom-content h3,.bottom-content h4,.bottom-content h5, .bottom-content h6{' . $bottom . '}';

        return $style;
    }


    function get_aphrodite_font_family($str) {
        $style = null;
        if ($str != '') {
            if (preg_match('/^(font-family:)/', $str)) {
                $style .= $str;
            } else {
                $style .= 'font-family: ' . $str;
            }
            if (!preg_match('/\;$/', $str)) {
                $style .= ';';
            }
        }
        return $style;
    }

    function get_aphrodite_data() {
        $content           = get_option('aphrodite_option');
        $aphrodite_default = aphrodite_default();
        $options           = array();
        if (empty($content) || $content == null) {
            $options = $aphrodite_default;
        } else {
            foreach ($aphrodite_default as $key => $val) {
                $options[$key] = isset($content[$key]) ? $content[$key] : $aphrodite_default[$key];
            }
        }

        return $options;
    }

    function set_aphrodite_data($data = array()) {
        if (empty($data)) {
            $data = aphrodite_default();
        }
        update_option('aphrodite_option', $data);
    }


    //  GetColor  returns  an  associative  array  with  the  red,  green  and  blue
    //  values  of  the  desired  color
    function  get_color_RGB($Color_name) {
        $Colors = ARRAY(
            //  Colors  as  they  are  defined  in  HTML  3.2
            "black"                => array("red" => 0x00, "green" => 0x00, "blue" => 0x00),
            "maroon"               => array("red" => 0x80, "green" => 0x00, "blue" => 0x00),
            "green"                => array("red" => 0x00, "green" => 0x80, "blue" => 0x00),
            "olive"                => array("red" => 0x80, "green" => 0x80, "blue" => 0x00),
            "navy"                 => array("red" => 0x00, "green" => 0x00, "blue" => 0x80),
            "purple"               => array("red" => 0x80, "green" => 0x00, "blue" => 0x80),
            "teal"                 => array("red" => 0x00, "green" => 0x80, "blue" => 0x80),
            "gray"                 => array("red" => 0x80, "green" => 0x80, "blue" => 0x80),
            "silver"               => array("red" => 0xC0, "green" => 0xC0, "blue" => 0xC0),
            "red"                  => array("red" => 0xFF, "green" => 0x00, "blue" => 0x00),
            "lime"                 => array("red" => 0x00, "green" => 0xFF, "blue" => 0x00),
            "yellow"               => array("red" => 0xFF, "green" => 0xFF, "blue" => 0x00),
            "blue"                 => array("red" => 0x00, "green" => 0x00, "blue" => 0xFF),
            "fuchsia"              => array("red" => 0xFF, "green" => 0x00, "blue" => 0xFF),
            "aqua"                 => array("red" => 0x00, "green" => 0xFF, "blue" => 0xFF),
            "white"                => array("red" => 0xFF, "green" => 0xFF, "blue" => 0xFF),

            //  Additional  colors  as  they  are  used  by  Netscape  and  IE
            "aliceblue"            => array("red" => 0xF0, "green" => 0xF8, "blue" => 0xFF),
            "antiquewhite"         => array("red" => 0xFA, "green" => 0xEB, "blue" => 0xD7),
            "aquamarine"           => array("red" => 0x7F, "green" => 0xFF, "blue" => 0xD4),
            "azure"                => array("red" => 0xF0, "green" => 0xFF, "blue" => 0xFF),
            "beige"                => array("red" => 0xF5, "green" => 0xF5, "blue" => 0xDC),
            "blueviolet"           => array("red" => 0x8A, "green" => 0x2B, "blue" => 0xE2),
            "brown"                => array("red" => 0xA5, "green" => 0x2A, "blue" => 0x2A),
            "burlywood"            => array("red" => 0xDE, "green" => 0xB8, "blue" => 0x87),
            "cadetblue"            => array("red" => 0x5F, "green" => 0x9E, "blue" => 0xA0),
            "chartreuse"           => array("red" => 0x7F, "green" => 0xFF, "blue" => 0x00),
            "chocolate"            => array("red" => 0xD2, "green" => 0x69, "blue" => 0x1E),
            "coral"                => array("red" => 0xFF, "green" => 0x7F, "blue" => 0x50),
            "cornflowerblue"       => array("red" => 0x64, "green" => 0x95, "blue" => 0xED),
            "cornsilk"             => array("red" => 0xFF, "green" => 0xF8, "blue" => 0xDC),
            "crimson"              => array("red" => 0xDC, "green" => 0x14, "blue" => 0x3C),
            "darkblue"             => array("red" => 0x00, "green" => 0x00, "blue" => 0x8B),
            "darkcyan"             => array("red" => 0x00, "green" => 0x8B, "blue" => 0x8B),
            "darkgoldenrod"        => array("red" => 0xB8, "green" => 0x86, "blue" => 0x0B),
            "darkgray"             => array("red" => 0xA9, "green" => 0xA9, "blue" => 0xA9),
            "darkgreen"            => array("red" => 0x00, "green" => 0x64, "blue" => 0x00),
            "darkkhaki"            => array("red" => 0xBD, "green" => 0xB7, "blue" => 0x6B),
            "darkmagenta"          => array("red" => 0x8B, "green" => 0x00, "blue" => 0x8B),
            "darkolivegreen"       => array("red" => 0x55, "green" => 0x6B, "blue" => 0x2F),
            "darkorange"           => array("red" => 0xFF, "green" => 0x8C, "blue" => 0x00),
            "darkorchid"           => array("red" => 0x99, "green" => 0x32, "blue" => 0xCC),
            "darkred"              => array("red" => 0x8B, "green" => 0x00, "blue" => 0x00),
            "darksalmon"           => array("red" => 0xE9, "green" => 0x96, "blue" => 0x7A),
            "darkseagreen"         => array("red" => 0x8F, "green" => 0xBC, "blue" => 0x8F),
            "darkslateblue"        => array("red" => 0x48, "green" => 0x3D, "blue" => 0x8B),
            "darkslategray"        => array("red" => 0x2F, "green" => 0x4F, "blue" => 0x4F),
            "darkturquoise"        => array("red" => 0x00, "green" => 0xCE, "blue" => 0xD1),
            "darkviolet"           => array("red" => 0x94, "green" => 0x00, "blue" => 0xD3),
            "deeppink"             => array("red" => 0xFF, "green" => 0x14, "blue" => 0x93),
            "deepskyblue"          => array("red" => 0x00, "green" => 0xBF, "blue" => 0xFF),
            "dimgray"              => array("red" => 0x69, "green" => 0x69, "blue" => 0x69),
            "dodgerblue"           => array("red" => 0x1E, "green" => 0x90, "blue" => 0xFF),
            "firebrick"            => array("red" => 0xB2, "green" => 0x22, "blue" => 0x22),
            "floralwhite"          => array("red" => 0xFF, "green" => 0xFA, "blue" => 0xF0),
            "forestgreen"          => array("red" => 0x22, "green" => 0x8B, "blue" => 0x22),
            "gainsboro"            => array("red" => 0xDC, "green" => 0xDC, "blue" => 0xDC),
            "ghostwhite"           => array("red" => 0xF8, "green" => 0xF8, "blue" => 0xFF),
            "gold"                 => array("red" => 0xFF, "green" => 0xD7, "blue" => 0x00),
            "goldenrod"            => array("red" => 0xDA, "green" => 0xA5, "blue" => 0x20),
            "greenyellow"          => array("red" => 0xAD, "green" => 0xFF, "blue" => 0x2F),
            "honeydew"             => array("red" => 0xF0, "green" => 0xFF, "blue" => 0xF0),
            "hotpink"              => array("red" => 0xFF, "green" => 0x69, "blue" => 0xB4),
            "indianred"            => array("red" => 0xCD, "green" => 0x5C, "blue" => 0x5C),
            "indigo"               => array("red" => 0x4B, "green" => 0x00, "blue" => 0x82),
            "ivory"                => array("red" => 0xFF, "green" => 0xFF, "blue" => 0xF0),
            "khaki"                => array("red" => 0xF0, "green" => 0xE6, "blue" => 0x8C),
            "lavender"             => array("red" => 0xE6, "green" => 0xE6, "blue" => 0xFA),
            "lavenderblush"        => array("red" => 0xFF, "green" => 0xF0, "blue" => 0xF5),
            "lawngreen"            => array("red" => 0x7C, "green" => 0xFC, "blue" => 0x00),
            "lemonchiffon"         => array("red" => 0xFF, "green" => 0xFA, "blue" => 0xCD),
            "lightblue"            => array("red" => 0xAD, "green" => 0xD8, "blue" => 0xE6),
            "lightcoral"           => array("red" => 0xF0, "green" => 0x80, "blue" => 0x80),
            "lightcyan"            => array("red" => 0xE0, "green" => 0xFF, "blue" => 0xFF),
            "lightgoldenrodyellow" => array("red" => 0xFA, "green" => 0xFA, "blue" => 0xD2),
            "lightgreen"           => array("red" => 0x90, "green" => 0xEE, "blue" => 0x90),
            "lightgrey"            => array("red" => 0xD3, "green" => 0xD3, "blue" => 0xD3),
            "lightpink"            => array("red" => 0xFF, "green" => 0xB6, "blue" => 0xC1),
            "lightsalmon"          => array("red" => 0xFF, "green" => 0xA0, "blue" => 0x7A),
            "lightseagreen"        => array("red" => 0x20, "green" => 0xB2, "blue" => 0xAA),
            "lightskyblue"         => array("red" => 0x87, "green" => 0xCE, "blue" => 0xFA),
            "lightslategray"       => array("red" => 0x77, "green" => 0x88, "blue" => 0x99),
            "lightsteelblue"       => array("red" => 0xB0, "green" => 0xC4, "blue" => 0xDE),
            "lightyellow"          => array("red" => 0xFF, "green" => 0xFF, "blue" => 0xE0),
            "limegreen"            => array("red" => 0x32, "green" => 0xCD, "blue" => 0x32),
            "linen"                => array("red" => 0xFA, "green" => 0xF0, "blue" => 0xE6),
            "mediumaquamarine"     => array("red" => 0x66, "green" => 0xCD, "blue" => 0xAA),
            "mediumblue"           => array("red" => 0x00, "green" => 0x00, "blue" => 0xCD),
            "mediumorchid"         => array("red" => 0xBA, "green" => 0x55, "blue" => 0xD3),
            "mediumpurple"         => array("red" => 0x93, "green" => 0x70, "blue" => 0xD0),
            "mediumseagreen"       => array("red" => 0x3C, "green" => 0xB3, "blue" => 0x71),
            "mediumslateblue"      => array("red" => 0x7B, "green" => 0x68, "blue" => 0xEE),
            "mediumspringgreen"    => array("red" => 0x00, "green" => 0xFA, "blue" => 0x9A),
            "mediumturquoise"      => array("red" => 0x48, "green" => 0xD1, "blue" => 0xCC),
            "mediumvioletred"      => array("red" => 0xC7, "green" => 0x15, "blue" => 0x85),
            "midnightblue"         => array("red" => 0x19, "green" => 0x19, "blue" => 0x70),
            "mintcream"            => array("red" => 0xF5, "green" => 0xFF, "blue" => 0xFA),
            "mistyrose"            => array("red" => 0xFF, "green" => 0xE4, "blue" => 0xE1),
            "moccasin"             => array("red" => 0xFF, "green" => 0xE4, "blue" => 0xB5),
            "navajowhite"          => array("red" => 0xFF, "green" => 0xDE, "blue" => 0xAD),
            "oldlace"              => array("red" => 0xFD, "green" => 0xF5, "blue" => 0xE6),
            "olivedrab"            => array("red" => 0x6B, "green" => 0x8E, "blue" => 0x23),
            "orange"               => array("red" => 0xFF, "green" => 0xA5, "blue" => 0x00),
            "orangered"            => array("red" => 0xFF, "green" => 0x45, "blue" => 0x00),
            "orchid"               => array("red" => 0xDA, "green" => 0x70, "blue" => 0xD6),
            "palegoldenrod"        => array("red" => 0xEE, "green" => 0xE8, "blue" => 0xAA),
            "palegreen"            => array("red" => 0x98, "green" => 0xFB, "blue" => 0x98),
            "paleturquoise"        => array("red" => 0xAF, "green" => 0xEE, "blue" => 0xEE),
            "palevioletred"        => array("red" => 0xDB, "green" => 0x70, "blue" => 0x93),
            "papayawhip"           => array("red" => 0xFF, "green" => 0xEF, "blue" => 0xD5),
            "peachpuff"            => array("red" => 0xFF, "green" => 0xDA, "blue" => 0xB9),
            "peru"                 => array("red" => 0xCD, "green" => 0x85, "blue" => 0x3F),
            "pink"                 => array("red" => 0xFF, "green" => 0xC0, "blue" => 0xCB),
            "plum"                 => array("red" => 0xDD, "green" => 0xA0, "blue" => 0xDD),
            "powderblue"           => array("red" => 0xB0, "green" => 0xE0, "blue" => 0xE6),
            "rosybrown"            => array("red" => 0xBC, "green" => 0x8F, "blue" => 0x8F),
            "royalblue"            => array("red" => 0x41, "green" => 0x69, "blue" => 0xE1),
            "saddlebrown"          => array("red" => 0x8B, "green" => 0x45, "blue" => 0x13),
            "salmon"               => array("red" => 0xFA, "green" => 0x80, "blue" => 0x72),
            "sandybrown"           => array("red" => 0xF4, "green" => 0xA4, "blue" => 0x60),
            "seagreen"             => array("red" => 0x2E, "green" => 0x8B, "blue" => 0x57),
            "seashell"             => array("red" => 0xFF, "green" => 0xF5, "blue" => 0xEE),
            "sienna"               => array("red" => 0xA0, "green" => 0x52, "blue" => 0x2D),
            "skyblue"              => array("red" => 0x87, "green" => 0xCE, "blue" => 0xEB),
            "slateblue"            => array("red" => 0x6A, "green" => 0x5A, "blue" => 0xCD),
            "slategray"            => array("red" => 0x70, "green" => 0x80, "blue" => 0x90),
            "snow"                 => array("red" => 0xFF, "green" => 0xFA, "blue" => 0xFA),
            "springgreen"          => array("red" => 0x00, "green" => 0xFF, "blue" => 0x7F),
            "steelblue"            => array("red" => 0x46, "green" => 0x82, "blue" => 0xB4),
            "tan"                  => array("red" => 0xD2, "green" => 0xB4, "blue" => 0x8C),
            "thistle"              => array("red" => 0xD8, "green" => 0xBF, "blue" => 0xD8),
            "tomato"               => array("red" => 0xFF, "green" => 0x63, "blue" => 0x47),
            "turquoise"            => array("red" => 0x40, "green" => 0xE0, "blue" => 0xD0),
            "violet"               => array("red" => 0xEE, "green" => 0x82, "blue" => 0xEE),
            "wheat"                => array("red" => 0xF5, "green" => 0xDE, "blue" => 0xB3),
            "whitesmoke"           => array("red" => 0xF5, "green" => 0xF5, "blue" => 0xF5),
            "yellowgreen"          => array("red" => 0x9A, "green" => 0xCD, "blue" => 0x32)
        );

        return isset($Colors[$Color_name]) ? $Colors[$Color_name] : $Color_name;
    }
    function hex2_to_rgb($hex) {
        $hex = str_replace("#", "", $hex);

        if(strlen($hex) == 3) {
            $r = hexdec(substr($hex,0,1).substr($hex,0,1));
            $g = hexdec(substr($hex,1,1).substr($hex,1,1));
            $b = hexdec(substr($hex,2,1).substr($hex,2,1));
        } else {
            $r = hexdec(substr($hex,0,2));
            $g = hexdec(substr($hex,2,2));
            $b = hexdec(substr($hex,4,2));
        }
        $rgb = array($r, $g, $b);
        //return implode(",", $rgb); // returns the rgb values separated by commas
        return $rgb; // returns an array with the rgb values
    }